/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.microservices.download.server.startup;

import ch.ethz.sis.microservices.download.api.configuration.Config;
import ch.ethz.sis.microservices.download.api.configuration.ServiceConfig;
import ch.ethz.sis.microservices.download.server.services.Service;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ServerLauncher {
    private static final Logger logger = Logger.getLogger(ServerLauncher.class);
    private final Server server;

    public ServerLauncher(Config config) throws Exception {
        this.server = new Server(config.getPort());
        ServiceConfig[] services = config.getServices();
        ServletHandler handler = new ServletHandler();
        this.server.setHandler((Handler)handler);
        for (ServiceConfig serviceConfig : services) {
            logger.info((Object)("Loading Service: " + serviceConfig.getClassName() + " URL: " + serviceConfig.getUrl()));
            Service service = (Service)((Object)Class.forName(serviceConfig.getClassName()).getConstructor(new Class[0]).newInstance(new Object[0]));
            service.setServiceConfig(serviceConfig);
            ServletHolder servletHolder = new ServletHolder((Servlet)service);
            handler.addServletWithMapping(servletHolder, serviceConfig.getUrl());
        }
        logger.info((Object)"Server Starting");
        this.server.start();
        logger.info((Object)"Server Started");
    }

    public Server getServer() {
        return this.server;
    }
}

