/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.io;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferRandomAccessFile
implements IRandomAccessFile {
    private final ByteBuffer buf;

    private void addToLength(int newItemLen) {
        int rem = this.buf.remaining();
        if (newItemLen > rem) {
            this.buf.limit(this.buf.limit() + (newItemLen - rem));
        }
    }

    public ByteBufferRandomAccessFile(ByteBuffer buf, int initialLength) {
        this(buf);
        this.setLength(initialLength);
    }

    public ByteBufferRandomAccessFile(ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteBufferRandomAccessFile(byte[] array, int initialLength) {
        this(array);
        this.setLength(initialLength);
    }

    public ByteBufferRandomAccessFile(byte[] array) {
        this(ByteBuffer.wrap(array));
    }

    public ByteBufferRandomAccessFile(int capacity) {
        this(ByteBuffer.allocate(capacity));
        this.setLength(0L);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.buf.order();
    }

    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
    }

    @Override
    public void readFully(byte[] b) throws IOExceptionUnchecked {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOExceptionUnchecked {
        if (this.available0() == -1) {
            throw new IOExceptionUnchecked(new EOFException());
        }
        this.buf.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOExceptionUnchecked {
        if (n <= 0) {
            return 0;
        }
        int pos = this.buf.position();
        int len = this.buf.limit();
        int newpos = Math.min(len, pos + n);
        this.buf.position(newpos);
        return newpos - pos;
    }

    @Override
    public void close() throws IOExceptionUnchecked {
    }

    @Override
    public int read() throws IOExceptionUnchecked {
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOExceptionUnchecked {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOExceptionUnchecked {
        int bytesRead = Math.min(this.available0(), len);
        if (bytesRead < 0) {
            return bytesRead;
        }
        this.buf.get(b, off, bytesRead);
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOExceptionUnchecked {
        if (n > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return this.skipBytes((int)n);
    }

    private int available0() throws IOExceptionUnchecked {
        return this.buf.remaining() == 0 ? -1 : this.buf.remaining();
    }

    @Override
    public int available() throws IOExceptionUnchecked {
        return this.buf.remaining();
    }

    @Override
    public void mark(int readlimit) {
        this.buf.mark();
    }

    @Override
    public void reset() throws IOExceptionUnchecked {
        this.buf.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void flush() throws IOExceptionUnchecked {
    }

    @Override
    public void synchronize() throws IOExceptionUnchecked {
    }

    @Override
    public long getFilePointer() throws IOExceptionUnchecked {
        return this.buf.position();
    }

    @Override
    public void seek(long pos) throws IOExceptionUnchecked {
        this.buf.position((int)pos);
    }

    @Override
    public long length() throws IOExceptionUnchecked {
        return this.buf.limit();
    }

    @Override
    public void setLength(long newLength) throws IOExceptionUnchecked {
        this.buf.limit((int)newLength);
    }

    @Override
    public boolean readBoolean() throws IOExceptionUnchecked {
        return this.buf.get() != 0;
    }

    @Override
    public byte readByte() throws IOExceptionUnchecked {
        return this.buf.get();
    }

    @Override
    public int readUnsignedByte() throws IOExceptionUnchecked {
        return this.buf.get() & 0xFF;
    }

    @Override
    public short readShort() throws IOExceptionUnchecked {
        return this.buf.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOExceptionUnchecked {
        return this.buf.getShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOExceptionUnchecked {
        return this.buf.getChar();
    }

    @Override
    public int readInt() throws IOExceptionUnchecked {
        return this.buf.getInt();
    }

    @Override
    public long readLong() throws IOExceptionUnchecked {
        return this.buf.getLong();
    }

    @Override
    public float readFloat() throws IOExceptionUnchecked {
        return this.buf.getFloat();
    }

    @Override
    public double readDouble() throws IOExceptionUnchecked {
        return this.buf.getDouble();
    }

    @Override
    public String readLine() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() {
        try {
            byte[] strBuf = new byte[this.readUnsignedShort()];
            this.buf.get(strBuf);
            return new String(strBuf, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void write(int b) throws IOExceptionUnchecked {
        this.addToLength(1);
        this.buf.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOExceptionUnchecked {
        this.addToLength(b.length);
        this.buf.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOExceptionUnchecked {
        this.addToLength(len);
        this.buf.put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOExceptionUnchecked {
        this.addToLength(1);
        this.buf.put((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) throws IOExceptionUnchecked {
        this.write((byte)v);
    }

    @Override
    public void writeShort(int v) throws IOExceptionUnchecked {
        this.addToLength(2);
        this.buf.putShort((short)v);
    }

    @Override
    public void writeChar(int v) throws IOExceptionUnchecked {
        this.addToLength(2);
        this.buf.putChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOExceptionUnchecked {
        this.addToLength(4);
        this.buf.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOExceptionUnchecked {
        this.addToLength(8);
        this.buf.putLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOExceptionUnchecked {
        this.addToLength(4);
        this.buf.putFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOExceptionUnchecked {
        this.addToLength(8);
        this.buf.putDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOExceptionUnchecked {
        int len = s.length();
        this.addToLength(len);
        for (int i = 0; i < len; ++i) {
            this.buf.put((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOExceptionUnchecked {
        int len = s.length();
        this.addToLength(2 * len);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buf.put((byte)(v >>> 8 & 0xFF));
            this.buf.put((byte)(v >>> 0 & 0xFF));
        }
    }

    @Override
    public void writeUTF(String str) throws UnsupportedOperationException {
        try {
            byte[] strBuf = str.getBytes("UTF-8");
            this.addToLength(2 + strBuf.length);
            this.writeShort(strBuf.length);
            this.write(strBuf);
        }
        catch (UnsupportedEncodingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }
}

