/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.logging.LoggerDiagnostics;
import ch.systemsx.cisd.common.logging.ext.DailyRollingFileHandler;
import ch.systemsx.cisd.common.logging.ext.LoggingUtils;
import ch.systemsx.cisd.common.logging.ext.NullHandler;
import ch.systemsx.cisd.common.logging.ext.PatternFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SocketHandler;
import java.util.stream.Collectors;

public class LogInitializer {
    private static final String LOG_DIRECTORY = "etc";
    private static final String LOG_FILENAME = "logging.properties";
    private static final String FILE_URL_PREFIX = "file:";
    private static final String GLOBAL_LEVEL_KEY = ".global.level";
    public static final String GLOBAL_HANDLERS = ".global.handlerAliases";
    public static final String INTERNAL_HANDLERS = ".handlerAliases";
    private static final String LEVEL_SUFFIX = ".level";
    public static final String LOG_FILE_NAME = ".logFileName";
    public static final String MAX_LOG_FILE_SIZE = ".maxLogFileSize";
    public static final String MESSAGE_PATTERN = ".messagePattern";
    public static final String ENCODING = ".encoding";
    public static final String MAX_LOG_ROTATIONS = ".maxLogRotations";
    public static final String APPEND = ".append";
    public static final String USE_PARENT_HANDLERS = ".useParentHandlers";
    private static boolean initialized;

    private static URL createURL(String configurationOrNull) {
        LoggerDiagnostics.info("createURL(config=" + configurationOrNull + ")");
        if (configurationOrNull != null) {
            try {
                LoggerDiagnostics.info("Trying URL string: " + configurationOrNull);
                return new URL(configurationOrNull);
            }
            catch (MalformedURLException ex) {
                LoggerDiagnostics.error("Malformed URL '" + configurationOrNull + "': " + ex.getMessage());
            }
        }
        URL resource = LogInitializer.class.getResource("/etc/logging.properties");
        LoggerDiagnostics.info("Classpath resource URL: " + String.valueOf(resource));
        return resource;
    }

    private static String tryFindConfigurationInSystemProperties() {
        String trimmed;
        String config = System.getProperty("log.configuration");
        LoggerDiagnostics.info("System property log.configuration=" + config);
        if (config != null && !(trimmed = config.trim()).isEmpty()) {
            LoggerDiagnostics.info("Using system property config: " + trimmed);
            return trimmed;
        }
        return null;
    }

    private static File getEffectiveLogFile(String configurationOrNull) {
        File file = configurationOrNull == null ? new File(LOG_DIRECTORY, LOG_FILENAME) : new File(configurationOrNull);
        LoggerDiagnostics.info("getEffectiveLogFile -> " + file.getAbsolutePath());
        return file;
    }

    public static synchronized void init() {
        LoggerDiagnostics.info("init() called. alreadyInitialized=" + initialized);
        if (initialized) {
            LoggerDiagnostics.info("Already initialized. Skipping.");
            return;
        }
        LogInitializer.initialize();
    }

    private static void initialize() {
        LoggerDiagnostics.info("Starting initialize()");
        String config = LogInitializer.tryFindConfigurationInSystemProperties();
        if (config == null || !config.startsWith(FILE_URL_PREFIX)) {
            File logFile = LogInitializer.getEffectiveLogFile(config);
            if (logFile.exists() && logFile.isFile()) {
                LoggerDiagnostics.info("Found log file: " + logFile.getAbsolutePath());
                LogInitializer.configureFromFile(logFile);
                initialized = true;
                LoggerDiagnostics.info("Initialized from file.");
                return;
            }
            LoggerDiagnostics.info("Log file not found: " + logFile.getAbsolutePath());
        }
        LoggerDiagnostics.info("Trying URL-based config (config=" + config + ")");
        URL url = LogInitializer.createURL(config);
        if (url != null) {
            LogInitializer.configureFromURL(url);
            initialized = true;
            LoggerDiagnostics.info("Initialized from URL.");
            return;
        }
        initialized = true;
        LoggerDiagnostics.info("No external config found. Initialization complete with defaults.");
    }

    public static void configureFromURL(URL url) {
        LoggerDiagnostics.info("configureFromURL(" + String.valueOf(url) + ")");
        try {
            File file = new File(url.toURI());
            LoggerDiagnostics.info("URL to URI path: " + file.getAbsolutePath());
            if (file.exists()) {
                LoggerDiagnostics.info("File exists at URL path. Delegating to configureFromFile.");
                LogInitializer.configureFromFile(file);
                return;
            }
        }
        catch (URISyntaxException e) {
            LoggerDiagnostics.error("URI syntax error: " + e.getMessage());
        }
        System.out.printf("Configured from URL '%s' (no watching)%n", url);
    }

    public static void configureFromFile(File logFile) {
        if (!logFile.getName().endsWith(".properties")) {
            String msg = String.format("Unsupported configuration file: '%s'.%nPlease supply a '.properties' file for logging setup.", logFile.getAbsolutePath());
            LoggerDiagnostics.info(msg);
            new IllegalArgumentException("Invalid file type").printStackTrace(System.out);
            return;
        }
        LoggerDiagnostics.info("configureFromFile(logFile=" + logFile.getAbsolutePath() + ")");
        LogInitializer.configureFromFile(logFile, null);
    }

    public static void configureFromFile(File logFileParam, List<String> loggersToInitialize) {
        Properties props;
        LoggerDiagnostics.info("configureFromFile(loggers override) called.");
        File logFile = logFileParam;
        if (logFileParam == null || logFileParam.getPath().trim().isEmpty()) {
            LoggerDiagnostics.error("No log file defined; using default logging.properties in cwd.");
            logFile = new File(LOG_FILENAME);
        }
        if ((props = LogInitializer.loadProperties(logFile)) == null) {
            LoggerDiagnostics.error("Properties load failed; aborting.");
            return;
        }
        try (FileInputStream in = new FileInputStream(logFile);){
            LogManager.getLogManager().readConfiguration(in);
            LoggerDiagnostics.info("[LogInitializer][Bootstrap] Loaded JUL config from " + String.valueOf(logFile));
        }
        catch (IOException ioe) {
            LoggerDiagnostics.info("[LogInitializer][Bootstrap] Couldn't to load JUL config from " + String.valueOf(logFile) + ": " + ioe.getMessage());
        }
        String handlersList = props.getProperty(GLOBAL_HANDLERS);
        if (handlersList == null) {
            LoggerDiagnostics.error("No 'handlers' property defined.");
            LogInitializer.configureGlobalLoggingLevel(props);
            return;
        }
        LoggerDiagnostics.info("Handlers to configure: " + handlersList);
        String[] splitHandlerAliases = handlersList.split("\\s*,\\s*");
        Set<String> handlerAliases = Arrays.stream(splitHandlerAliases).map(String::trim).collect(Collectors.toSet());
        LogInitializer.removeAllHandlersBeforeInitialization();
        LogInitializer.configureGlobalLoggingLevel(props);
        for (String alias : handlerAliases) {
            LoggerDiagnostics.info("Initializing handler: " + alias);
            try {
                Handler handler = LogInitializer.createHandler(alias, props);
                LogInitializer.configureCommonProperties(handler, alias, props);
                Logger.getLogger("").addHandler(handler);
                LoggerDiagnostics.info("Handler added: " + String.valueOf(handler));
            }
            catch (Exception e) {
                LoggerDiagnostics.error("Error initializing handler '" + alias + "': " + e.getMessage(), e);
            }
        }
        for (String propertyKey : props.stringPropertyNames()) {
            if (!propertyKey.endsWith(INTERNAL_HANDLERS) || propertyKey.equals(GLOBAL_HANDLERS)) continue;
            String loggerName = propertyKey.substring(0, propertyKey.length() - INTERNAL_HANDLERS.length());
            String[] loggerAliases = props.getProperty(propertyKey).split("\\s*,\\s*");
            Logger logger = null;
            try {
                LoggerDiagnostics.error(logFile.getAbsolutePath() + " : " + loggerName);
                logger = Logger.getLogger(loggerName);
            }
            catch (Throwable e) {
                System.out.println(logFile.getAbsolutePath() + String.valueOf(e));
                throw new RuntimeException(logFile.getAbsolutePath(), e);
            }
            for (Handler h : logger.getHandlers()) {
                logger.removeHandler(h);
            }
            for (String loggerAlias : loggerAliases) {
                try {
                    Handler handler = LogInitializer.createHandler(loggerAlias, props);
                    LogInitializer.configureCommonProperties(handler, loggerAlias, props);
                    logger.setUseParentHandlers(LogInitializer.useParentHandlers(loggerName, props));
                    logger.addHandler(handler);
                    LoggerDiagnostics.info("Attached handler '" + (String)loggerAlias + "' to logger '" + loggerName + "'");
                }
                catch (Exception e) {
                    LoggerDiagnostics.error("Failed to attach handler '" + (String)loggerAlias + "' to logger '" + loggerName + "': " + e.getMessage(), e);
                }
            }
        }
        LogInitializer.configureSpecificLoggerLevels(props, handlerAliases);
    }

    private static boolean useParentHandlers(String loggerName, Properties props) {
        String useParentHandlersKey = loggerName + USE_PARENT_HANDLERS;
        String useParentHandlersValue = props.getProperty(useParentHandlersKey);
        boolean useParentHandlers = false;
        if (useParentHandlersValue != null) {
            useParentHandlers = Boolean.parseBoolean(useParentHandlersValue.trim());
        }
        return useParentHandlers;
    }

    private static void removeAllHandlersBeforeInitialization() {
        LoggerDiagnostics.info("removeAllHandlersBeforeInitialization()");
        Logger root = Logger.getLogger("");
        for (Handler h : root.getHandlers()) {
            LoggerDiagnostics.info("Removing handler: " + String.valueOf(h));
            root.removeHandler(h);
        }
        LoggerDiagnostics.info("also reset : LogManager.getLogManager().reset()");
    }

    private static Properties loadProperties(File configurationFile) {
        LoggerDiagnostics.info("loadProperties(file=" + configurationFile.getPath() + ")");
        Properties props = new Properties();
        InputStream is = null;
        boolean loaded = false;
        if (configurationFile.exists() && configurationFile.isFile()) {
            try {
                LoggerDiagnostics.info("Loading properties from filesystem: " + configurationFile.getAbsolutePath());
                is = new FileInputStream(configurationFile);
            }
            catch (IOException e) {
                LoggerDiagnostics.error("IOException opening file: " + e.getMessage());
            }
        } else {
            LoggerDiagnostics.info("File not found on filesystem; will try classpath lookup.");
        }
        if (is == null) {
            String resourcePath = configurationFile.getPath().replace(File.separatorChar, '/');
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            LoggerDiagnostics.info("Trying classpath resource: " + resourcePath);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                is = cl.getResourceAsStream(resourcePath);
                LoggerDiagnostics.info("ContextClassLoader resourceStream=" + (is != null));
            }
            if (is == null) {
                is = LogInitializer.class.getResourceAsStream("/" + resourcePath);
                LoggerDiagnostics.info("Class.getResourceAsStream(/" + resourcePath + ")=" + (is != null));
                if (is == null) {
                    is = LogInitializer.class.getResourceAsStream(resourcePath);
                    LoggerDiagnostics.info("Class.getResourceAsStream(" + resourcePath + ")=" + (is != null));
                }
            }
        }
        if (is != null) {
            try (FileInputStream in = is;){
                props.load(in);
                loaded = true;
                LoggerDiagnostics.info("Properties loaded successfully.");
            }
            catch (IOException e) {
                LoggerDiagnostics.error("Error loading properties: " + e.getMessage());
            }
        } else {
            LoggerDiagnostics.error("Could not find configuration resource: " + configurationFile.getPath());
        }
        return loaded ? props : null;
    }

    private static void configureGlobalLoggingLevel(Properties props) {
        Level lvl;
        LoggerDiagnostics.info("configureGlobalLoggingLevel");
        String global = props.getProperty(GLOBAL_LEVEL_KEY);
        LoggerDiagnostics.info(".global.level=" + global);
        if (global != null && !global.isEmpty() && (lvl = LogInitializer.tryGetLogLevel(global)) != null) {
            Logger.getLogger("").setLevel(lvl);
            LoggerDiagnostics.info("Root logger level set to " + String.valueOf(lvl));
        }
    }

    private static Level tryGetLogLevel(String levelStr) {
        LoggerDiagnostics.info("tryGetLogLevel(" + levelStr + ")");
        if (levelStr == null || levelStr.isEmpty()) {
            return null;
        }
        try {
            org.apache.log4j.Level log4jLevel = org.apache.log4j.Level.parse(levelStr);
            Level jul = LoggingUtils.mapToJULLevel(log4jLevel);
            LoggerDiagnostics.info("Parsed log4j level " + String.valueOf(log4jLevel) + " -> JUL level " + String.valueOf(jul));
            return jul;
        }
        catch (Exception e) {
            try {
                Level jul = Level.parse(levelStr);
                LoggerDiagnostics.info("Parsed JUL level " + String.valueOf(jul));
                return jul;
            }
            catch (Exception ex) {
                LoggerDiagnostics.error("Failed to parse level: " + levelStr);
                return null;
            }
        }
    }

    private static Handler createHandler(String alias, Properties props) throws Exception {
        Handler handler;
        LoggerDiagnostics.info("createHandler(alias=" + alias + ")");
        String className = props.getProperty(alias + ".class");
        LoggerDiagnostics.info("Handler class name=" + className);
        if (className == null) {
            throw new IllegalArgumentException("No class defined for handler alias: \"" + alias + "\"");
        }
        Class<?> hc = Class.forName(className);
        if (DailyRollingFileHandler.class.isAssignableFrom(hc)) {
            String pattern = props.getProperty(alias + LOG_FILE_NAME);
            int maxLogFileSize = Integer.parseInt(props.getProperty(alias + MAX_LOG_FILE_SIZE, String.valueOf(-1)));
            boolean append = Boolean.parseBoolean(props.getProperty(alias + APPEND, "false"));
            int maxLogRotations = Integer.parseInt(props.getProperty(alias + MAX_LOG_ROTATIONS, String.valueOf(7)));
            LoggerDiagnostics.info("Using file-handler constructor: pattern=" + pattern + ", maxLogFileSize=" + maxLogFileSize + ", maxLogRotations=" + maxLogRotations + ", append=" + append);
            handler = (Handler)hc.getConstructor(String.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE).newInstance(pattern, maxLogFileSize, append, maxLogRotations);
        } else if (ConsoleHandler.class.isAssignableFrom(hc) || NullHandler.class.isAssignableFrom(hc) || Handler.class.isAssignableFrom(hc)) {
            LoggerDiagnostics.info("Using no-arg constructor for handler");
            handler = (Handler)hc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            throw new IllegalArgumentException("Handler not found : " + String.valueOf(hc));
        }
        return handler;
    }

    private static void configureCommonProperties(Handler handler, String alias, Properties props) throws Exception {
        String formatterClassName;
        String levelStr = props.getProperty(alias + LEVEL_SUFFIX);
        if (levelStr != null) {
            handler.setLevel(LogInitializer.tryGetLogLevel(levelStr));
        }
        if ((formatterClassName = props.getProperty(alias + ".formatter")) != null) {
            Class<?> formatterClass = Class.forName(formatterClassName);
            Formatter formatter = (Formatter)formatterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            handler.setFormatter(formatter);
        } else {
            String messagePattern = props.getProperty(alias + MESSAGE_PATTERN);
            if (messagePattern != null) {
                PatternFormatter patternFormatter = new PatternFormatter(messagePattern);
                handler.setFormatter(patternFormatter);
            }
        }
        String encoding = props.getProperty(alias + ENCODING);
        if (encoding != null) {
            handler.setEncoding(encoding);
        }
    }

    private static void configureSocketHandler(SocketHandler handler, String alias, Properties props) {
        String portStr;
        String host = props.getProperty(alias + ".host");
        if (host != null) {
            try {
                Method setHost = handler.getClass().getMethod("setHost", String.class);
                setHost.invoke((Object)handler, host);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Field hostField = handler.getClass().getDeclaredField("host");
                    hostField.setAccessible(true);
                    hostField.set(handler, host);
                }
                catch (Exception ex) {
                    LoggerDiagnostics.error("Could not set host for SocketHandler for alias: " + alias);
                }
            }
            catch (Exception e) {
                LoggerDiagnostics.error("Error setting host for SocketHandler for alias: " + alias);
            }
        }
        if ((portStr = props.getProperty(alias + ".port")) != null) {
            int port = Integer.parseInt(portStr);
            try {
                Method setPort = handler.getClass().getMethod("setPort", Integer.TYPE);
                setPort.invoke((Object)handler, port);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Field portField = handler.getClass().getDeclaredField("port");
                    portField.setAccessible(true);
                    portField.set(handler, port);
                }
                catch (Exception ex) {
                    LoggerDiagnostics.error("Could not set port for SocketHandler for alias: " + alias);
                }
            }
            catch (Exception e) {
                LoggerDiagnostics.error("Error setting port for SocketHandler for alias: " + alias);
            }
        }
    }

    private static void configureSpecificLoggerLevels(Properties props, Set<String> handlerAliases) {
        LoggerDiagnostics.info("Configuring specific logger levels...");
        for (String key : props.stringPropertyNames()) {
            if (!key.endsWith(LEVEL_SUFFIX) || key.equals(GLOBAL_LEVEL_KEY)) continue;
            String loggerName = key.substring(0, key.length() - LEVEL_SUFFIX.length());
            if (handlerAliases.contains(loggerName)) {
                LoggerDiagnostics.debug("Skipping handler level key: " + key);
                continue;
            }
            String levelStr = props.getProperty(key);
            Level level = LogInitializer.tryGetLogLevel(levelStr);
            if (level != null) {
                try {
                    Logger logger = Logger.getLogger(loggerName);
                    logger.setLevel(level);
                    LoggerDiagnostics.info("Set level " + level.getName() + " for logger '" + loggerName + "'");
                }
                catch (Exception e) {
                    LoggerDiagnostics.error("ERROR: Could not set level for logger '" + loggerName + "' from property '" + key + "': " + e.getMessage());
                    e.printStackTrace(System.err);
                }
                continue;
            }
            LoggerDiagnostics.error("WARNING: Could not parse level '" + levelStr + "' for logger property '" + key + "'. Level not set.");
        }
        LoggerDiagnostics.info("Finished configuring specific logger levels.");
    }

    public static void forceReinit() {
        initialized = false;
        LoggerDiagnostics.info("forceReinit() called.");
        LogInitializer.init();
    }

    static {
        System.setProperty("log4j.defaultInitOverride", "true");
        LoggerDiagnostics.debug("Static init: log4j.defaultInitOverride=true");
        System.setProperty("org.jboss.logging.provider", "jdk");
        initialized = false;
    }
}

