/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.shared.log.standard.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public abstract class AbstractFileHandler
extends Handler {
    public static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    public static final int DEFAULT_MAX_LOG_FILE_SIZE = -1;
    protected final int maxLogFileSize;
    protected final boolean append;
    protected final String logFileName;
    protected long currentSize;
    protected File currentFile;
    protected FileOutputStream outputStream;
    protected final Charset encoding;
    protected final ReentrantLock lock = new ReentrantLock();

    public AbstractFileHandler(String logFileName, int maxLogFileSize, boolean append) {
        this(logFileName, maxLogFileSize, append, DEFAULT_ENCODING);
    }

    public AbstractFileHandler(String logFileName, int maxLogFileSize, boolean append, Charset encoding) {
        this.logFileName = logFileName;
        this.maxLogFileSize = maxLogFileSize;
        this.append = append;
        this.encoding = encoding;
    }

    protected byte[] getMessageBytes(LogRecord record) {
        byte[] bytes;
        try {
            String msg = this.getFormatter().format(record);
            bytes = msg.getBytes(this.encoding);
        }
        catch (Exception e) {
            this.reportError("Formatting error", e, 5);
            return null;
        }
        return bytes;
    }

    protected static int getNextIndex(File parentDir, final String prefix) {
        File[] existing = parentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.substring(prefix.length()).matches("\\d+");
            }
        });
        int nextIndex = 1;
        if (existing != null) {
            for (File f : existing) {
                try {
                    int idx = Integer.parseInt(f.getName().substring(prefix.length()));
                    if (idx < nextIndex) continue;
                    nextIndex = idx + 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return nextIndex;
    }

    public abstract void customPublishLogic(byte[] var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        byte[] bytes = this.getMessageBytes(record);
        if (bytes == null) {
            return;
        }
        this.lock.lock();
        try {
            this.customPublishLogic(bytes);
            this.outputStream.write(bytes);
            this.outputStream.flush();
            this.currentSize += (long)bytes.length;
        }
        catch (IOException e) {
            this.reportError(null, e, 1);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() {
        this.lock.lock();
        try {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }
        catch (IOException e) {
            this.reportError(null, e, 2);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SecurityException {
        this.lock.lock();
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            this.reportError(null, e, 3);
        }
        finally {
            this.lock.unlock();
        }
    }
}

