/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging.log;

import ch.systemsx.cisd.common.logging.log.LogCategory;
import java.util.logging.Logger;

public final class LogFactory {
    private LogFactory() {
    }

    public static String getLoggerName(LogCategory category, Class<?> clazz) {
        return category.name() + "." + clazz.getSimpleName();
    }

    public static String getLoggerName(LogCategory category) {
        if (!category.isAdminLog()) {
            throw new IllegalArgumentException("Only admin logs are allowed here, but we got " + String.valueOf((Object)category) + ".");
        }
        return category.name();
    }

    public static Logger getLogger(LogCategory category, Class<?> clazz) {
        return Logger.getLogger(LogFactory.getLoggerName(category, clazz));
    }

    public static Logger getLogger(LogCategory category) {
        return Logger.getLogger(LogFactory.getLoggerName(category));
    }

    public static Logger getRootLogger() {
        return Logger.getLogger("root");
    }
}

