/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.microservices.download.server.services.store;

import ch.ethz.sis.microservices.download.server.services.store.AbstractFileServiceHandler;
import ch.ethz.sis.shared.log.standard.LogManager;
import ch.ethz.sis.shared.log.standard.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadHandler
extends AbstractFileServiceHandler {
    private static Logger logger = LogManager.getLogger(DownloadHandler.class);
    private static final int BUFFER_SIZE = 1024;

    @Override
    protected void success(Path pathToFile, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String offsetP = request.getParameter("offset");
        long offset = 0L;
        if (offsetP != null) {
            offset = Long.parseLong(offsetP);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset can't be negative");
        }
        long size = Files.size(pathToFile) - offset;
        if (size < 0L) {
            throw new IllegalArgumentException("offset to read starts beyond end of file");
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + pathToFile.getFileName().toString());
        response.setHeader("Content-Length", Long.toString(size));
        InputStream is = Files.newInputStream(pathToFile, new OpenOption[0]);
        is.skip(offset);
        DownloadHandler.copy(is, (OutputStream)response.getOutputStream(), size);
        response.setStatus(200);
    }

    private static void copy(InputStream source, OutputStream destination, long sourceSize) throws IOException {
        int readed;
        byte[] buf = new byte[1024];
        while ((readed = source.read(buf)) > 0) {
            destination.write(buf, 0, readed);
        }
    }

    @Override
    protected void failure(Path pathToFile, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(404);
    }
}

