/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.common;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.ITableCell;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.ObjectToString;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableColumn;
import ch.systemsx.cisd.base.annotation.JsonObject;
import java.io.Serializable;
import java.util.List;

@JsonObject(value="as.dto.common.TableModel")
public class TableModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<TableColumn> columns;
    private List<List<ITableCell>> rows;

    public TableModel(List<TableColumn> columns, List<List<ITableCell>> rows) {
        if (columns == null) {
            throw new IllegalArgumentException("Unspecified table columns.");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("No table column specified.");
        }
        this.columns = columns;
        if (rows == null) {
            throw new IllegalArgumentException("Unspecified table rows.");
        }
        for (int i = 0; i < rows.size(); ++i) {
            List<ITableCell> row = rows.get(i);
            if (row == null) {
                throw new IllegalArgumentException(i + 1 + ". row is not specified.");
            }
            if (row.size() == columns.size()) continue;
            throw new IllegalArgumentException(i + 1 + ". row has " + row.size() + " cells instead of " + columns.size() + ".");
        }
        this.rows = rows;
    }

    public List<TableColumn> getColumns() {
        return this.columns;
    }

    public List<List<ITableCell>> getRows() {
        return this.rows;
    }

    private TableModel() {
    }

    private void setColumns(List<TableColumn> columns) {
        this.columns = columns;
    }

    private void setRows(List<List<ITableCell>> rows) {
        this.rows = rows;
    }

    public String toString() {
        return new ObjectToString(this).append("columns", this.columns).append("rowCount", this.rows != null ? this.rows.size() : 0).toString();
    }
}

