/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.shared.log.classic.impl;

import ch.ethz.sis.shared.log.classic.ISimpleLogger;
import ch.ethz.sis.shared.log.classic.core.LogLevel;
import ch.ethz.sis.shared.log.classic.impl.Logger;
import ch.ethz.sis.shared.log.standard.core.Level;
import ch.ethz.sis.shared.log.standard.core.Priority;

public class SimpleLogger
implements ISimpleLogger {
    private final Priority log4jOverridePriorityOrNull;
    private final Logger log4jLogger;

    public static final Level toLog4jPriority(LogLevel level) {
        switch (level) {
            case OFF: {
                return Level.OFF;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        throw new IllegalArgumentException("Illegal log level " + String.valueOf((Object)level));
    }

    public SimpleLogger(Logger log4jLogger, Priority log4jOverridePriorityOrNull) {
        assert (log4jLogger != null) : "Unspecified log4j logger";
        this.log4jOverridePriorityOrNull = log4jOverridePriorityOrNull;
        this.log4jLogger = log4jLogger;
    }

    public SimpleLogger(Logger log4jLogger) {
        this(log4jLogger, null);
    }

    @Override
    public void log(LogLevel level, String message) {
        this.log(level, message, null);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwableOrNull) {
        if (this.log4jOverridePriorityOrNull != null) {
            this.log4jLogger.log(this.log4jOverridePriorityOrNull, message, throwableOrNull);
        } else {
            this.log4jLogger.log(SimpleLogger.toLog4jPriority(level), message, throwableOrNull);
        }
    }
}

