/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.shared.log.standard.handlers;

import ch.ethz.sis.shared.log.classic.core.LogCategory;
import ch.ethz.sis.shared.log.classic.core.LogLevel;
import ch.ethz.sis.shared.log.classic.ext.LogAnnotation;
import ch.ethz.sis.shared.log.classic.impl.LogFactory;
import ch.ethz.sis.shared.log.classic.impl.Logger;
import ch.ethz.sis.shared.log.classic.impl.SimpleLogger;
import ch.ethz.sis.shared.log.standard.core.Level;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;

public final class LogInvocationHandler
implements InvocationHandler {
    private final Object object;
    private final String name;
    private final Level defaultLogLevel;
    private final Class<?> classUsedToNameLogger;
    private final boolean onlyIfAnnotated;

    public LogInvocationHandler(Object object, String name, Level logLevel, Class<?> classUsedToNameLogger) {
        this(object, name, logLevel, classUsedToNameLogger, false);
    }

    public LogInvocationHandler(Object object, String name, Level logLevel, Class<?> classUsedToNameLogger, boolean onlyIfAnnotated) {
        this.object = object;
        this.name = name;
        this.defaultLogLevel = logLevel;
        this.classUsedToNameLogger = classUsedToNameLogger;
        this.onlyIfAnnotated = onlyIfAnnotated;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        long time = System.currentTimeMillis();
        Throwable throwable = null;
        try {
            object = method.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            try {
                throwable = e.getCause();
                throw throwable;
                catch (UndeclaredThrowableException e2) {
                    throwable = e2.getCause();
                    throw throwable;
                }
                catch (Throwable t) {
                    throwable = t;
                    throw t;
                }
            }
            catch (Throwable throwable2) {
                LogAnnotation logAnnotationOrNull = this.tryGetAnnotation(method);
                if (this.onlyIfAnnotated) {
                    if (logAnnotationOrNull == null) throw throwable2;
                }
                Level logLevel = this.getLogLevel(method, logAnnotationOrNull);
                Logger logger = this.createLogger(method, logAnnotationOrNull);
                if (throwable == null) {
                    if (!logger.isEnabledFor(logLevel)) throw throwable2;
                }
                StringBuilder builder = new StringBuilder(throwable == null ? "Successful" : "Failed");
                builder.append(" invocation of ");
                builder.append(this.name).append('.').append(method.getName()).append('(');
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        builder.append(args[i]);
                        if (i >= args.length - 1) continue;
                        builder.append(", ");
                    }
                }
                builder.append(") took ").append(System.currentTimeMillis() - time).append(" msec");
                if (throwable == null) {
                    logger.log(logLevel, builder.toString());
                    throw throwable2;
                }
                logger.error(builder.toString(), throwable);
                throw throwable2;
            }
        }
        LogAnnotation logAnnotationOrNull = this.tryGetAnnotation(method);
        if (this.onlyIfAnnotated) {
            if (logAnnotationOrNull == null) return object;
        }
        Level logLevel = this.getLogLevel(method, logAnnotationOrNull);
        Logger logger = this.createLogger(method, logAnnotationOrNull);
        if (throwable == null) {
            if (!logger.isEnabledFor(logLevel)) return object;
        }
        StringBuilder builder = new StringBuilder(throwable == null ? "Successful" : "Failed");
        builder.append(" invocation of ");
        builder.append(this.name).append('.').append(method.getName()).append('(');
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                builder.append(args[i]);
                if (i >= args.length - 1) continue;
                builder.append(", ");
            }
        }
        builder.append(") took ").append(System.currentTimeMillis() - time).append(" msec");
        if (throwable == null) {
            logger.log(logLevel, builder.toString());
            return object;
        }
        logger.error(builder.toString(), throwable);
        return object;
    }

    private final LogAnnotation tryGetAnnotation(Method method) {
        return method.getAnnotation(LogAnnotation.class);
    }

    private final Level getLogLevel(Method method, LogAnnotation annotationOrNull) {
        if (annotationOrNull == null) {
            return Level.DEBUG;
        }
        if (annotationOrNull.logLevel().equals((Object)LogLevel.UNDEFINED)) {
            return this.defaultLogLevel;
        }
        return SimpleLogger.toLog4jPriority(annotationOrNull.logLevel());
    }

    private final Logger createLogger(Method method, LogAnnotation annotationOrNull) {
        LogCategory logCategory = annotationOrNull == null ? LogCategory.OPERATION : annotationOrNull.logCategory();
        return LogFactory.getLogger(logCategory, this.classUsedToNameLogger);
    }
}

