/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.AbstractBulkInputStream;
import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.IChunkQueue;
import ch.ethz.sis.filetransfer.IChunkSerializer;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.LogLevel;
import java.io.IOException;
import java.io.InputStream;

class DownloadInputStream
extends AbstractBulkInputStream {
    private ILogger logger;
    private IChunkQueue chunkQueue;
    private IChunkSerializer chunkSerializer;
    private Integer numberOfChunksOrNull;
    private InputStream chunkStream;
    private int sequenceNumber;

    public DownloadInputStream(ILogger logger, IChunkQueue chunkQueue, IChunkSerializer chunkSerializer, Integer numberOfChunksOrNull) {
        this.logger = logger;
        this.chunkQueue = chunkQueue;
        this.chunkSerializer = chunkSerializer;
        this.numberOfChunksOrNull = numberOfChunksOrNull;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        block11: {
            int n;
            if (this.chunkStream == null) {
                Chunk chunk;
                if (this.numberOfChunksOrNull != null) {
                    if (this.numberOfChunksOrNull > 0) {
                        this.numberOfChunksOrNull = this.numberOfChunksOrNull - 1;
                    } else {
                        return -1;
                    }
                }
                if ((chunk = this.chunkQueue.poll()) == null) {
                    return -1;
                }
                this.sequenceNumber = chunk.getSequenceNumber();
                if (this.logger.isEnabled(LogLevel.DEBUG)) {
                    this.logger.log(this.getClass(), LogLevel.DEBUG, "Starting to read chunk " + this.sequenceNumber);
                }
                try {
                    this.chunkStream = this.chunkSerializer.serialize(chunk);
                }
                catch (DownloadException e) {
                    throw new IOException("Couldn't serialize a chunk " + this.sequenceNumber, e);
                }
            }
            if ((n = this.chunkStream.read(b, off, len)) >= 0) {
                return n;
            }
            try {
                this.chunkStream.close();
            }
            catch (Exception e) {
                if (!this.logger.isEnabled(LogLevel.WARN)) break block11;
                this.logger.log(this.getClass(), LogLevel.WARN, "Couldn't close the stream for chunk " + this.sequenceNumber, e);
            }
        }
        this.chunkStream = null;
        return this.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.chunkStream != null) {
            this.chunkStream.close();
        }
    }
}

