/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.ObjectToString;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDescriptionHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.EntityKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginKind;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.PluginType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.fetchoptions.PluginFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.plugin.id.PluginPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;

@JsonObject(value="as.dto.plugin.Plugin")
public class Plugin
implements Serializable,
IDescriptionHolder,
IPermIdHolder,
IRegistrationDateHolder,
IRegistratorHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private PluginFetchOptions fetchOptions;
    @JsonProperty
    private String name;
    @JsonProperty
    private PluginPermId permId;
    @JsonProperty
    private String description;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private PluginKind pluginKind;
    @JsonProperty
    private Set<EntityKind> entityKinds;
    @JsonProperty
    private PluginType pluginType;
    @JsonProperty
    private String script;
    @JsonProperty
    private boolean available;

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public PluginPermId getPermId() {
        return this.permId;
    }

    public void setPermId(PluginPermId permId) {
        this.permId = permId;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public PluginFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(PluginFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @JsonIgnore
    public PluginKind getPluginKind() {
        return this.pluginKind;
    }

    public void setPluginKind(PluginKind pluginType) {
        this.pluginKind = pluginType;
    }

    @JsonIgnore
    public Set<EntityKind> getEntityKinds() {
        return this.entityKinds;
    }

    public void setEntityKinds(Set<EntityKind> entityKinds) {
        this.entityKinds = entityKinds;
    }

    @JsonIgnore
    public PluginType getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    @JsonIgnore
    public String getScript() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasScript()) {
            return this.script;
        }
        throw new NotFetchedException("Script has not been fetched.");
    }

    public void setScript(String script) {
        this.script = script;
    }

    @JsonIgnore
    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public String toString() {
        return new ObjectToString(this).append("permId", this.permId).toString();
    }
}

