/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.exceptions;

import ch.systemsx.cisd.common.exceptions.StatusFlag;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class Status {
    private final StatusFlag flag;
    private final String errorMessageOrNull;
    public static final Status OK = new Status(StatusFlag.OK, null);

    public static Status createError(boolean retriable) {
        return new Status(Status.getErrorFlag(retriable), "");
    }

    public static Status createError(boolean retriable, String message) {
        assert (message != null);
        return new Status(Status.getErrorFlag(retriable), message);
    }

    public static Status createError() {
        return new Status(StatusFlag.ERROR, "");
    }

    public static Status createError(String message) {
        assert (message != null);
        return new Status(StatusFlag.ERROR, message);
    }

    public static Status createError(String messageTemplate, Object ... args) {
        assert (messageTemplate != null);
        return new Status(StatusFlag.ERROR, String.format(messageTemplate, args));
    }

    public static Status createRetriableError() {
        return new Status(StatusFlag.RETRIABLE_ERROR, "");
    }

    public static Status createRetriableError(String message) {
        assert (message != null);
        return new Status(StatusFlag.RETRIABLE_ERROR, message);
    }

    public static Status createRetriableError(String messageTemplate, Object ... args) {
        assert (messageTemplate != null);
        return new Status(StatusFlag.RETRIABLE_ERROR, String.format(messageTemplate, args));
    }

    protected static StatusFlag getErrorFlag(boolean retriable) {
        return retriable ? StatusFlag.RETRIABLE_ERROR : StatusFlag.ERROR;
    }

    protected Status(StatusFlag flag, String message) {
        assert (flag != null);
        assert (StatusFlag.OK.equals((Object)flag) || message != null);
        this.flag = flag;
        this.errorMessageOrNull = message;
    }

    public StatusFlag getFlag() {
        return this.flag;
    }

    public final boolean isOK() {
        return this.flag == StatusFlag.OK;
    }

    public final boolean isError() {
        return this.flag != StatusFlag.OK;
    }

    public final boolean isRetriableError() {
        return this.flag == StatusFlag.RETRIABLE_ERROR;
    }

    public final boolean isNonRetriableError() {
        return this.flag == StatusFlag.ERROR;
    }

    public String tryGetErrorMessage() {
        return this.errorMessageOrNull;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Status)) {
            return false;
        }
        Status that = (Status)obj;
        return this.getFlag() == that.getFlag() && ObjectUtils.equals(this.tryGetErrorMessage(), that.tryGetErrorMessage());
    }

    public int hashCode() {
        return (17 + this.flag.hashCode()) * 37 + ObjectUtils.hashCode(this.tryGetErrorMessage());
    }

    public String toString() {
        if (StringUtils.isNotBlank(this.errorMessageOrNull)) {
            return this.flag.toString() + ": \"" + this.errorMessageOrNull + "\"";
        }
        return this.flag.toString();
    }
}

