/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.TimeoutCompleteListener;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpChannel {
    protected static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final HttpDestination _destination;
    private final TimeoutCompleteListener _totalTimeout;
    private HttpExchange _exchange;

    protected HttpChannel(HttpDestination destination) {
        this._destination = destination;
        this._totalTimeout = new TimeoutCompleteListener(destination.getHttpClient().getScheduler());
    }

    public void destroy() {
        this._totalTimeout.destroy();
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean associate(HttpExchange exchange2) {
        boolean result = false;
        boolean abort = true;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            if (this._exchange == null) {
                abort = false;
                result = exchange2.associate(this);
                if (result) {
                    this._exchange = exchange2;
                }
            }
        }
        if (abort) {
            exchange2.getRequest().abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("{} associated {} to {}", exchange2, result, this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disassociate(HttpExchange exchange2) {
        boolean result = false;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            HttpExchange existing = this._exchange;
            this._exchange = null;
            if (existing == exchange2) {
                existing.disassociate(this);
                result = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} disassociated {} from {}", exchange2, result, this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpExchange getHttpExchange() {
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            return this._exchange;
        }
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    public void send() {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 != null) {
            HttpRequest request = exchange2.getRequest();
            long timeoutAt = request.getTimeoutAt();
            if (timeoutAt != -1L) {
                exchange2.getResponseListeners().add(this._totalTimeout);
                this._totalTimeout.schedule(request, timeoutAt);
            }
            this.send(exchange2);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    public void proceed(HttpExchange exchange2, Throwable failure) {
        this.getHttpSender().proceed(exchange2, failure);
    }

    public boolean abort(HttpExchange exchange2, Throwable requestFailure, Throwable responseFailure) {
        boolean requestAborted = false;
        if (requestFailure != null) {
            requestAborted = this.getHttpSender().abort(exchange2, requestFailure);
        }
        boolean responseAborted = false;
        if (responseFailure != null) {
            responseAborted = this.abortResponse(exchange2, responseFailure);
        }
        return requestAborted || responseAborted;
    }

    public boolean abortResponse(HttpExchange exchange2, Throwable failure) {
        return this.getHttpReceiver().abort(exchange2, failure);
    }

    public Result exchangeTerminating(HttpExchange exchange2, Result result) {
        return result;
    }

    public void exchangeTerminated(HttpExchange exchange2, Result result) {
        this.disassociate(exchange2);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange());
    }
}

