/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc3.J3Connection;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class Driver
implements java.sql.Driver {
    public static final int DEBUG = 2;
    public static final int INFO = 1;
    public static boolean logDebug = false;
    public static boolean logInfo = false;
    private static String[] protocols;
    private static int m_buildNumber;

    public Connection connect(String string, Properties properties) throws SQLException {
        Properties properties2 = this.parseURL(string, properties);
        if (properties2 == null) {
            if (logDebug) {
                Driver.debug("Error in url" + string);
            }
            return null;
        }
        try {
            if (logDebug) {
                Driver.debug("connect " + string);
            }
            J3Connection j3Connection = (J3Connection)Class.forName("com.filemaker.jdbc3.J3Connection").newInstance();
            j3Connection.openConnection(this.host(properties2), this.port(properties2), properties2, this.database(properties2), string, this);
            return j3Connection;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logDebug) {
                Driver.debug("error", classNotFoundException);
            }
            throw new FMSQLException("The fmjdbc.jar file does not contain the correct JDBC classes for this JVM.", "60000");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            if (logDebug) {
                Driver.debug("error", exception);
            }
            throw new FMSQLException(exception.getMessage(), "99999");
        }
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.parseURL(string, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        this.parseURL(string, properties);
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 12;
    }

    public int getMinorVersion() {
        return 3;
    }

    public static String getVersion() {
        return "FileMaker 12.3.103 JDBC3 (build " + m_buildNumber + ")";
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String string, Properties properties) throws SQLException {
        int n;
        int n2 = -1;
        Properties properties2 = new Properties(properties);
        String string2 = string;
        String string3 = "";
        int n3 = string.indexOf(63);
        if (n3 != -1) {
            string2 = string.substring(0, n3);
            string3 = string.substring(n3 + 1);
        }
        int n4 = string2.indexOf("[");
        int n5 = string2.indexOf("]");
        String string4 = null;
        if (n4 != -1 && n5 > n4) {
            string4 = string2.substring(n4 + 1, n5);
            string2 = string2.substring(0, n4) + "ipv6host" + string2.substring(n5 + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/", true);
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (n6 <= 3) {
                if (n6 % 2 != 1 || !string5.equals(":")) {
                    if (n6 % 2 != 0) return null;
                    boolean bl = n6 == 0;
                    for (n = 0; n < protocols.length; ++n) {
                        if (!string5.equals(protocols[n]) || n6 != 2 || n <= 0) continue;
                        properties2.put("Protocol", string5);
                        bl = true;
                    }
                    if (!bl) {
                        return null;
                    }
                }
            } else if (n6 > 3) {
                if (n6 == 4 && string5.equals("/")) {
                    n2 = 0;
                } else if (n6 == 4) {
                    properties2.put("FMDBNAME", string5);
                    n2 = -2;
                } else if (n6 == 5 && n2 == 0 && string5.equals("/")) {
                    n2 = 1;
                } else {
                    if (n6 == 5 && n2 == 0) {
                        return null;
                    }
                    if (n6 == 6 && n2 == 1) {
                        properties2.put("FMHOST", string5);
                    } else if (n6 == 7 && string5.equals(":")) {
                        n2 = 2;
                    } else if (n6 == 8 && n2 == 2) {
                        try {
                            Integer n7 = Integer.decode(string5);
                            properties2.put("FMPORT", n7.toString());
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    } else if (!(n6 != 7 && n6 != 9 || n2 != 1 && n2 != 2 || !string5.equals("/"))) {
                        n2 = -1;
                    } else if (n2 == -1) {
                        properties2.put("FMDBNAME", string5);
                        n2 = -2;
                    }
                }
            }
            ++n6;
        }
        if (string4 != null) {
            properties2.put("FMHOST", string4);
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "&");
        int n8 = 0;
        while (stringTokenizer2.hasMoreTokens()) {
            String string6 = stringTokenizer2.nextToken();
            n = string6.indexOf(61);
            if (n == -1) {
                properties2.put(string6, "");
            } else {
                properties2.put(string6.substring(0, n), string6.substring(n + 1));
            }
            ++n8;
        }
        return properties2;
    }

    public String host(Properties properties) {
        return properties.getProperty("FMHOST", "localhost");
    }

    public int port(Properties properties) {
        return Integer.parseInt(properties.getProperty("FMPORT", "2399"));
    }

    public String database(Properties properties) {
        return properties.getProperty("FMDBNAME", "");
    }

    public static SQLException notImplemented() {
        return new FMSQLException("This method is not yet implemented.", "0A000");
    }

    public static void setLogLevel(int n) {
        logDebug = n >= 2;
        logInfo = n >= 1;
    }

    public static void debug(String string) {
        if (logDebug) {
            DriverManager.println(string);
        }
    }

    public static void debug(String string, Exception exception) {
        if (logDebug) {
            DriverManager.println(string);
            if (exception != null) {
                DriverManager.println(exception.toString());
            }
        }
    }

    public static void info(String string) {
        if (logInfo) {
            DriverManager.println(string);
        }
    }

    public static void info(String string, Exception exception) {
        if (logInfo) {
            DriverManager.println(string);
            if (exception != null) {
                DriverManager.println(exception.toString());
            }
        }
    }

    public static void makeSSL(FMStream fMStream) throws IOException {
    }

    public static boolean sslEnabled() {
        boolean bl = false;
        return bl;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        protocols = new String[]{"jdbc", "filemaker"};
        m_buildNumber = 1;
    }
}

