/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.Chunk;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.FileChunk;
import ch.ethz.sis.filetransfer.IChunkProvider;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FileSystemChunkProvider
implements IChunkProvider {
    private ILogger logger;
    private long chunkSize;

    public FileSystemChunkProvider(ILogger logger, long chunkSize) {
        this.logger = logger;
        this.chunkSize = chunkSize;
    }

    protected abstract Path getFilePath(IDownloadItemId var1);

    @Override
    public Map<IDownloadItemId, List<Chunk>> getChunks(List<IDownloadItemId> itemIds) throws DownloadException {
        HashMap<IDownloadItemId, List<Chunk>> result = new HashMap<IDownloadItemId, List<Chunk>>();
        AtomicInteger sequenceNumber = new AtomicInteger(0);
        for (IDownloadItemId itemId : itemIds) {
            Path itemFilePath = this.getFilePath(itemId);
            List<Chunk> chunks = this.getChunks(sequenceNumber, itemId, itemFilePath.getParent(), itemFilePath);
            result.put(itemId, chunks);
        }
        return result;
    }

    private List<Chunk> getChunks(AtomicInteger sequenceNumber, IDownloadItemId itemId, Path rootFilePath, Path filePath) throws DownloadException {
        LinkedList<Chunk> chunks = new LinkedList<Chunk>();
        try {
            if (filePath.toFile().isDirectory()) {
                chunks.add(new DirectoryChunk(sequenceNumber.getAndIncrement(), itemId, rootFilePath.relativize(filePath).toString()));
                File[] fileArray = filePath.toFile().listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    chunks.addAll(this.getChunks(sequenceNumber, itemId, rootFilePath, file.toPath()));
                    ++n2;
                }
            } else {
                long fileSize = Files.size(filePath);
                long fileOffset = 0L;
                do {
                    int payloadLength = (int)(Math.min(fileOffset + this.chunkSize, fileSize) - fileOffset);
                    chunks.add(new FileChunk(sequenceNumber.getAndIncrement(), itemId, rootFilePath.relativize(filePath).toString(), fileOffset, payloadLength, filePath, this.logger));
                } while ((fileOffset += this.chunkSize) < fileSize);
            }
        }
        catch (IOException e) {
            throw new DownloadException("Couldn't get chunk for file path: " + filePath, e, true);
        }
        return chunks;
    }

    private class DirectoryChunk
    extends Chunk {
        public DirectoryChunk(int sequenceNumber, IDownloadItemId downloadItemId, String filePath) {
            super(sequenceNumber, downloadItemId, true, filePath, 0L, 0);
        }

        @Override
        public InputStream getPayload() throws DownloadException {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
        }
    }
}

