/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDataSetsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDescriptionHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IExperimentsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IMaterialsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IOwnerHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISamplesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.material.Material;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.fetchoptions.TagFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@JsonObject(value="as.dto.tag.Tag")
public class Tag
implements Serializable,
ICodeHolder,
IDataSetsHolder,
IDescriptionHolder,
IExperimentsHolder,
IMaterialsHolder,
IOwnerHolder,
IPermIdHolder,
IRegistrationDateHolder,
ISamplesHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private TagFetchOptions fetchOptions;
    @JsonProperty
    private TagPermId permId;
    @JsonProperty
    private String code;
    @JsonProperty
    private String description;
    @JsonProperty(value="private")
    private Boolean isPrivate;
    @JsonProperty
    private List<Experiment> experiments;
    @JsonProperty
    private List<Sample> samples;
    @JsonProperty
    private List<DataSet> dataSets;
    @JsonProperty
    private List<Material> materials;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private Person owner;

    @JsonIgnore
    public TagFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(TagFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public TagPermId getPermId() {
        return this.permId;
    }

    public void setPermId(TagPermId permId) {
        this.permId = permId;
    }

    @Override
    @JsonIgnore
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public Boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Override
    @JsonIgnore
    public List<Experiment> getExperiments() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasExperiments()) {
            return this.experiments;
        }
        throw new NotFetchedException("Experiments have not been fetched.");
    }

    public void setExperiments(List<Experiment> experiments) {
        this.experiments = experiments;
    }

    @Override
    @JsonIgnore
    public List<Sample> getSamples() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSamples()) {
            return this.samples;
        }
        throw new NotFetchedException("Samples have not been fetched.");
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    @Override
    @JsonIgnore
    public List<DataSet> getDataSets() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasDataSets()) {
            return this.dataSets;
        }
        throw new NotFetchedException("Data sets have not been fetched.");
    }

    public void setDataSets(List<DataSet> dataSets) {
        this.dataSets = dataSets;
    }

    @Override
    @JsonIgnore
    public List<Material> getMaterials() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasMaterials()) {
            return this.materials;
        }
        throw new NotFetchedException("Materials have not been fetched.");
    }

    public void setMaterials(List<Material> materials) {
        this.materials = materials;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @JsonIgnore
    public Person getOwner() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasOwner()) {
            return this.owner;
        }
        throw new NotFetchedException("Owner has not been fetched.");
    }

    public void setOwner(Person owner) {
        this.owner = owner;
    }

    public String toString() {
        return "Tag " + this.code;
    }
}

